CREATE TABLE `prefix_warrules` (
`id` SMALLINT( 5 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
`zahl` SMALLINT( 6 ) DEFAULT '0' NOT NULL ,
`titel` VARCHAR( 200 ) NOT NULL ,
`text` TEXT NOT NULL ,
PRIMARY KEY ( `id` ) ,
FULLTEXT (
`titel` ,
`text`
)
);

CREATE TABLE `prefix_serverrules` (
`id` SMALLINT( 5 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
`zahl` SMALLINT( 6 ) DEFAULT '0' NOT NULL ,
`titel` VARCHAR( 200 ) NOT NULL ,
`text` TEXT NOT NULL ,
PRIMARY KEY ( `id` ) ,
FULLTEXT (
`titel` ,
`text`
)
);

CREATE TABLE `prefix_konto` (
  `id` int(14) unsigned NOT NULL default '1',
  `kontoinhaber` varchar(50) NOT NULL default '',
  `kreditinstitut` varchar(50) NOT NULL default '',
  `kontonummer` varchar(50) NOT NULL default '',
  `blz` varchar(50) NOT NULL default '',
  `iban` varchar(50) NOT NULL default '',
  `bic` varchar(50) NOT NULL default '',
  `verwendungszweck` varchar(255) NOT NULL default '',
  `kontosaldo` varchar(50) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by silentforces.de';

CREATE TABLE `prefix_kasse` (
  `id` int(14) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `verwendung` varchar(50) NOT NULL default '',
  `plus` varchar(50) NOT NULL default '',
  `minus` varchar(50)  NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by silentforces.de' AUTO_INCREMENT=1;

CREATE TABLE `prefix_partners1` (
  `id` smallint(6) NOT NULL auto_increment,
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `banner` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_bonuspoints` (
  `uid` int(10) NOT NULL default '0',
  `points` int(50) NOT NULL default '0'
)TYPE=MyISAM COMMENT='powered by silentforces.de';

CREATE TABLE `ilchclan_vertretpl` (
  `termin` text NOT NULL,
  `was` text NOT NULL,
  `deltimes` text NOT NULL,
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by C. Hilden';

CREATE TABLE `prefix_allg` (
  `id` int(5) unsigned NOT NULL auto_increment,
  `k` varchar(255) NOT NULL default '',
  `v1` varchar(255) NOT NULL default '',
  `v2` varchar(255) NOT NULL default '',
  `v3` varchar(255) NOT NULL default '',
  `v4` varchar(255) NOT NULL default '',
  `v5` varchar(255) NOT NULL default '',
  `v6` varchar(255) NOT NULL default '',
  `t1` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_awards` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `time` int(20) NOT NULL default '0',
  `platz` varchar(10) NOT NULL default '',
  `team` varchar(100) NOT NULL default '',
  `wofur` text NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_awaycal` (
  `id` int(14) unsigned NOT NULL auto_increment,
  `nick` char(80) default NULL,
  `uid` tinyint(3) default NULL,
  `pruef` tinyint(2) default '2',
  `von` date default NULL,
  `bis` date default NULL,
  `betreff` char(255) default NULL,
  PRIMARY KEY (`id`)
) TYPE=MyISAM COMMENT='powered by silentforces.de';

CREATE TABLE `prefix_counter` (
  `date` date NOT NULL default '0000-00-00',
  `count` smallint(5) NOT NULL default '0'
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_downcats` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_downloads` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `time` datetime NOT NULL default '0000-00-00 00:00:00',
  `creater` varchar(250) default NULL,
  `version` varchar(20) default NULL,
  `hits` int(11) NOT NULL default '0',
  `downs` int(11) NOT NULL default '0',
  `url` varchar(100) NOT NULL default '',
  `surl` varchar(100) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) default NULL,
  `descl` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_forumcats` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `pos` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_forums` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cid` mediumint(8) NOT NULL default '0',
  `last_post_id` int(11) NOT NULL default '0',
  `view` smallint(6) NOT NULL default '0',
  `reply` smallint(6) NOT NULL default '0',
  `start` smallint(6) NOT NULL default '0',
  `mods` smallint(6) NOT NULL default '0',
  `pos` tinyint(3) NOT NULL default '0',
  `posts` mediumint(8) NOT NULL default '0',
  `topics` mediumint(8) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `besch` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_gbook` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `mail` varchar(100) NOT NULL default '',
  `page` varchar(100) NOT NULL default '',
  `time` int(20) NOT NULL default '0',
  `ip` varchar(20) NOT NULL default '',
  `txt` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_groups` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_groupusers` (
  `uid` mediumint(9) NOT NULL default '0',
  `gid` smallint(6) NOT NULL default '0',
  `fid` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`uid`,`gid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_history` (
  `id` smallint(6) NOT NULL auto_increment,
  `date` date NOT NULL default '0000-00-00',
  `title` varchar(100) NOT NULL default '',
  `txt` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_koms` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uid` varchar(15) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `text` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_linkcats` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_links` (
  `id` smallint(6) NOT NULL auto_increment,
  `cat` mediumint(8) default '0',
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `desc` varchar(255) NOT NULL default '',
  `banner` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_menu` (
  `id` smallint(6) NOT NULL auto_increment,
  `sub` smallint(6) NOT NULL default '0',
  `wo` tinyint(1) NOT NULL default '0',
  `pos` tinyint(4) NOT NULL default '0',
  `was` tinyint(1) NOT NULL default '0',
  `recht` tinyint(2) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_modulerights` (
  `uogid` mediumint(9) NOT NULL default '0',
  `module` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`uogid`,`module`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_modules` (
  `module` varchar(20) NOT NULL default '',
  `gshow` tinyint(1) NOT NULL default '0',
  `ashow` tinyint(1) NOT NULL default '0',
  `fright` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`module`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_news` (
  `news_id` int(10) unsigned NOT NULL auto_increment,
  `news_title` varchar(100) NOT NULL default '',
  `user_id` int(11) NOT NULL default '0',
  `news_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `news_recht` int(11) NOT NULL default '0',
  `news_kat` varchar(100) NOT NULL default '',
  `news_text` text NOT NULL,
  PRIMARY KEY  (`news_id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_newsletter` (
  `email` varchar(100) NOT NULL default ''
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_online` (
  `uid` int(10) NOT NULL default '0',
  `uptime` int(20) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `ip` varchar(20) NOT NULL default '',
  `sid` varchar(35) NOT NULL default ''
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_partners` (
  `id` smallint(6) NOT NULL auto_increment,
  `pos` smallint(6) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `banner` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_pm` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `sid` mediumint(8) NOT NULL default '0',
  `eid` mediumint(8) NOT NULL default '0',
  `gelesen` tinyint(1) NOT NULL default '0',
  `time` int(20) NOT NULL default '0',
  `titel` varchar(100) NOT NULL default '',
  `txt` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_poll` (
  `poll_id` mediumint(8) unsigned NOT NULL auto_increment,
  `frage` varchar(200) NOT NULL default '',
  `recht` tinyint(1) NOT NULL default '0',
  `stat` tinyint(1) NOT NULL default '0',
  `text` text NOT NULL,
  PRIMARY KEY  (`poll_id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_poll_res` (
  `sort` tinyint(2) NOT NULL default '0',
  `poll_id` mediumint(8) NOT NULL default '0',
  `antw` varchar(100) NOT NULL default '',
  `res` tinyint(4) NOT NULL default '0'
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_posts` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `tid` mediumint(8) NOT NULL default '0',
  `fid` mediumint(9) NOT NULL default '0',
  `erst` varchar(100) NOT NULL default '',
  `erstid` int(10) NOT NULL default '0',
  `time` bigint(20) NOT NULL default '0',
  `txt` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_profilefields` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `change` varchar(100) NOT NULL default '',
  `show` varchar(100) NOT NULL default '',
  `pos` int(11) NOT NULL default '0',
  `udel` tinyint(1) NOT NULL default '0',
  `func` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_ranks` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `bez` varchar(100) NOT NULL default '',
  `min` int(10) NOT NULL default '0',
  `spez` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_rules` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `zahl` smallint(6) NOT NULL default '0',
  `titel` varchar(200) NOT NULL default '',
  `text` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_smilies` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `ent` varchar(50) NOT NULL default '',
  `url` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_shoutbox` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `nickname` varchar(50) NOT NULL default '',
  `textarea` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_stats` (
  `wtag` tinyint(2) NOT NULL default '0',
  `stunde` tinyint(2) NOT NULL default '0',
  `day` tinyint(2) NOT NULL default '0',
  `mon` tinyint(2) NOT NULL default '0',
  `yar` int(4) NOT NULL default '0',
  `os` varchar(50) NOT NULL default '',
  `browser` varchar(50) NOT NULL default '',
  `ip` varchar(20) NOT NULL default '',
  `ref` varchar(255) NOT NULL default ''
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_teams` (
  `gid` smallint(6) NOT NULL default '0',
  `img` varchar(100) NOT NULL default '',
  `mod` mediumint(9) NOT NULL default '0',
  `pos` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`gid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_topics` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `fid` int(10) NOT NULL default '0',
  `last_post_id` mediumint(9) NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `erst` varchar(100) NOT NULL default '',
  `art` int(1) NOT NULL default '0',
  `stat` int(1) NOT NULL default '0',
  `rep` int(10) NOT NULL default '0',
  `hit` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_user` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `pass` varchar(32) NOT NULL default '',
  `recht` int(1) NOT NULL default '0',
  `posts` int(5) NOT NULL default '0',
  `regist` int(20) default NULL,
  `email` varchar(100) NOT NULL default '',
  `llogin` int(20) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_usercheck` (
  `check` varchar(100) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `pass` varchar(100) NOT NULL default '',
  `datime` datetime NOT NULL default '0000-00-00 00:00:00',
  `ak` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`check`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_userfields` (
  `uid` mediumint(8) NOT NULL default '0',
  `fid` mediumint(8) NOT NULL default '0',
  `val` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`uid`,`fid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_userfuncs` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `pos` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_warmaps` (
  `wid` smallint(6) NOT NULL default '0',
  `mnr` tinyint(4) NOT NULL default '0',
  `map` varchar(100) NOT NULL default '',
  `opp` smallint(6) NOT NULL default '0',
  `owp` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`wid`,`mnr`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_warmember` (
  `wid` smallint(6) NOT NULL default '0',
  `uid` mediumint(9) NOT NULL default '0',
  `aktion` tinyint(1) NOT NULL default '0',
  `kom` text NOT NULL
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_wars` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `datime` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` tinyint(2) NOT NULL default '0',
  `wlp` tinyint(1) NOT NULL default '0',
  `owp` smallint(6) NOT NULL default '0',
  `opp` smallint(6) NOT NULL default '0',
  `gegner` varchar(100) NOT NULL default '',
  `page` varchar(100) NOT NULL default '',
  `tid` smallint(6) NOT NULL default '0',
  `mod` varchar(100) NOT NULL default '',
  `game` varchar(100) NOT NULL default '',
  `mtyp` varchar(100) NOT NULL default '',
  `land` varchar(100) NOT NULL default '',
  `txt` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

INSERT INTO `prefix_modules` VALUES ('warrules', 1, 1, 1);
INSERT INTO `prefix_modules` VALUES ('serverrules', 1, 1, 1);
INSERT INTO prefix_modules VALUES ('kasse', 1, 1, 1);
INSERT INTO prefix_konto VALUES ('','Max Mustermann', 'Musterstadtbank', '123456', '123456', '123456', '123456', 'Grade erst installiert', 0);
INSERT INTO prefix_partners1 VALUES ('', '0', 'Zocker-Eppingen', 'http://www.zocker-eppingen.de/include/images/banner/17.jpg', 'http://www.zocker-eppingen.de');
INSERT INTO prefix_modules VALUES ('bonus', 0, 1, 1);
INSERT INTO prefix_allg VALUES ('', 'kontakt', '', '1', '1', '', '', '', '');
INSERT INTO `prefix_allg` VALUES ('', 'impressum', 'Verantwortlich fr diese Seite:', 'Max Mustermann', 'Strasse, Nr', 'PLZ, Ort', '', '', 'Text');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gbook_posts_per_site', '20', 't', 'Gstebuch Optionen', '', '', 'Eintrge pro Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gallery_imgs_per_line', '4', 't', 'Gallery Optionen', '', '', 'Bilder pro Zeile');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Aanz', '3', 't', 'Archiv Optionen', '', '', 'Anzahl Banner in der Partner Box');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Nlimit', '5', 't', 'News Optionen', '', '', 'News pro Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Ftanz', '10', 't', 'Forum Optionen', '', '', 'Themen auf einer Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Fpanz', '15', 't', 'Forum Optionen', '', '', 'Posts auf einer Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'forum_avatar_upload', '1', 'r2', 'Forum Optionen', '', '', 'Avatar Upload?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gallery_imgs_per_site', '12', 't', 'Gallery Optionen', '', '', 'Bilder pro Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gallery_preview_width', '50', 't', 'Gallery Optionen', '', '', 'Breite der Vorschaubilder');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Fpmf', '1', 'r2', 'Forum Optionen', '', '', 'Nachrichten Function');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'gfx', 'ilchClan', 's', 'Allgemeine Optionen', '', '', 'Standart Design');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'adminMail', 'dddd', 't', 'Allgemeine Optionen', '', '', 'Administrator eMail');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'smodul', 'news', 's', 'Allgemeine Optionen', '', '', 'Start Modul der Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'title', 'Das Clanscript fr jeden!', 't', 'Allgemeine Optionen', '', '', 'Titel der Seite');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Flogintry', '5', 't', 'Forum Optionen', '', '', 'Login Versuche');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Fabreite', '80', 't', 'Forum Optionen', '', '', 'max Breite fr den avata');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Fahohe', '80', 't', 'Forum Optionen', '', '', 'max Hhe fr den avata');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Fasize', '16161', 't', 'Forum Optionen', '', '', 'max Gre in Bytes fr den avata');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Gsperre', '3600', 't', 'Gstebuch Optionen', '', '', 'Ip Sperre in Sekunden');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Gtxtl', '600', 't', 'Gstebuch Optionen', '', '', 'max Text lnge im Gstebuch');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Aart', '0', 'r2', 'Archiv Optionen', '', '', 'Soll die Partner Box sortiert werden');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Ngkoms', '1', 'r2', 'News Optionen', '', '', 'Drfen Gste Kommentare schreiben?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'Nukoms', '1', 'r2', 'News Optionen', '', '', 'Drfen User Kommentare schreiben?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'allg_menupoint_access', '1', 'r2', 'Allgemeine Optionen', '', '', 'Zugriff auf nicht im Men verlinkte Module fr alle?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'forum_regist', '1', 'r2', 'Forum Optionen', '', '', 'Drfen sich User registrieren?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'forum_regist_user_pass', '0', 'r2', 'Forum Optionen', '', '', 'Passwort vom User beim registrieren selber whlbar?');
INSERT INTO `prefix_allg` VALUES ('', 'ALLG', 'forum_regist_confirm_link', '1', 'r2', 'Forum Optionen', '', '', 'Registrierung per Link im eMail besttigen?');

INSERT INTO `prefix_menu` VALUES (1, 1, 1, 0, 2, 0, 'Men', 'allianz.php');
INSERT INTO `prefix_menu` VALUES (2, 2, 1, 11, 2, 0, 'Clan Men', 'allianz.php');
INSERT INTO `prefix_menu` VALUES (3, 3, 1, 22, 1, 0, 'Login', 'login.php');
INSERT INTO `prefix_menu` VALUES (4, 1, 1, 2, 3, 0, 'News', '?m=news');
INSERT INTO `prefix_menu` VALUES (5, 1, 1, 10, 3, 0, 'Links', '?m=links');
INSERT INTO `prefix_menu` VALUES (6, 1, 1, 8, 3, 0, 'Downloads', '?m=downloads');
INSERT INTO `prefix_menu` VALUES (7, 1, 1, 9, 3, 0, 'Gallery', '?m=gallery');
INSERT INTO `prefix_menu` VALUES (8, 1, 1, 3, 3, 0, 'Forum', '?m=forum');
INSERT INTO `prefix_menu` VALUES (9, 1, 1, 4, 3, 0, 'Kontakt', '?m=contact');
INSERT INTO `prefix_menu` VALUES (10, 1, 1, 5, 3, 0, 'Gstebuch', '?m=gbook');
INSERT INTO `prefix_menu` VALUES (11, 2, 1, 13, 3, 0, 'Wars', '?m=wars');
INSERT INTO `prefix_menu` VALUES (13, 2, 1, 19, 3, 0, 'AwayCal', '?m=awaycal');
INSERT INTO `prefix_menu` VALUES (15, 2, 1, 14, 3, 0, 'Awards', '?m=awards');
INSERT INTO `prefix_menu` VALUES (16, 2, 1, 21, 3, 0, 'Fightus', '?m=fightus');
INSERT INTO `prefix_menu` VALUES (17, 2, 1, 20, 3, 0, 'Joinus', '?m=joinus');
INSERT INTO `prefix_menu` VALUES (18, 2, 1, 15, 3, 0, 'Regeln', '?m=rules');
INSERT INTO `prefix_menu` VALUES (20, 2, 1, 12, 3, 0, 'Squads', '?m=teams');
INSERT INTO `prefix_menu` VALUES (21, 1, 1, 7, 3, 0, 'Mitglieder', '?m=user');
INSERT INTO `prefix_menu` VALUES (22, 22, 2, 1, 1, 0, 'Umfrage', 'vote.php');
INSERT INTO `prefix_menu` VALUES (23, 23, 2, 2, 1, 0, 'Allianz', 'allianz.php');
INSERT INTO `prefix_menu` VALUES (24, 24, 2, 3, 1, 0, 'Statistik', 'statistik.php');
INSERT INTO `prefix_menu` VALUES (25, 25, 2, 4, 1, 0, 'Lastwars', 'lastwars.php');
INSERT INTO `prefix_menu` VALUES (26, 26, 2, 5, 1, 0, 'Nextwars', 'nextwars.php');
INSERT INTO `prefix_menu` VALUES (27, 27, 2, 6, 1, 0, 'Newsletter', 'newsletter.php');
INSERT INTO `prefix_menu` VALUES (28, 28, 2, 7, 1, 0, 'Last Forum', 'lastforum.php');
INSERT INTO `prefix_menu` VALUES (29, 29, 2, 8, 1, 0, 'Last News', 'lastnews.php');
INSERT INTO `prefix_menu` VALUES (30, 30, 2, 9, 1, 0, 'Designs', 'designs.php');
INSERT INTO `prefix_menu` VALUES (31, 31, 1, 23, 1, 0, 'Shoutbox', 'shoutbox.php');
INSERT INTO `prefix_menu` VALUES (32, 1, 1, 6, 3, 0, 'Impressum', '?m=impressum');
INSERT INTO `prefix_menu` VALUES (33, 2, 1, 18, 3, 0, 'History', '?m=history');
INSERT INTO `prefix_menu` VALUES (34, 34, 1, 24, 1, 0, 'ICQ Status', 'icq.php');
INSERT INTO `prefix_menu` VALUES (35, 35, 2, 10, 1, 0, 'pic of', 'picofx.php');
INSERT INTO `prefix_menu` VALUES (36, 1, 1, 1, 3, 0, 'Startseite', '?m=startseite');
INSERT INTO `prefix_menu` VALUES (37, 37, 1, 25, 1, 0, 'Uhr', 'uhr.htm');
INSERT INTO `prefix_menu` VALUES (38, 38, 2, 0, 1, 0, 'Sponsor', 'allianz2.php');
INSERT INTO `prefix_menu` VALUES (39, 39, 1, 26, 1, 0, 'Birthday', 'birthdays.php');
INSERT INTO `prefix_menu` VALUES (40, 40, 2, 11, 1, 0, 'Last Reg', 'lastreg.php');
INSERT INTO `prefix_menu` VALUES (43, 43, 2, 13, 1, 0, 'Top Download', 'bdown.php');
INSERT INTO `prefix_menu` VALUES (42, 42, 2, 12, 1, 0, 'New Downloads', 'ndown.php');
INSERT INTO `prefix_menu` VALUES (44, 44, 1, 27, 1, 0, 'suchen', 'suchen.php');
INSERT INTO `prefix_menu` VALUES (45, 45, 2, 14, 1, 0, 'Last Gbook', 'gbook.php');
INSERT INTO `prefix_menu` VALUES (46, 2, 1, 17, 3, 0, 'Server Regeln', '?m=serverrules');
INSERT INTO `prefix_menu` VALUES (47, 2, 1, 16, 3, 0, 'War Regeln', '?m=warrules');

INSERT INTO prefix_modules VALUES ('gallery', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('news', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('teams', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('groups', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('rules', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('awards', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('wars', 1, 0, 1);
INSERT INTO prefix_modules VALUES ('forumsite', 0, 0, 1);
INSERT INTO prefix_modules VALUES ('forum', 1, 0, 1);

INSERT INTO prefix_profilefields VALUES (1, 'Wohnort', 'Wohnort', 0, 0, 1);
INSERT INTO prefix_profilefields VALUES (2, 'PrivMsg aktivieren?', 'PrivMsg', 9, 0, 3);
INSERT INTO prefix_profilefields VALUES (3, 'von Usern eMails?', 'eMail', 8, 0, 3);
INSERT INTO prefix_profilefields VALUES (4, 'Homepage', 'Homepage', 10, 0, 1);
INSERT INTO prefix_profilefields VALUES (5, 'Signature', 'Signature', 5, 0, 4);
INSERT INTO prefix_profilefields VALUES (6, 'Avatar', 'Avatar', 6, 0, 2);
INSERT INTO prefix_profilefields VALUES (7, 'ICQ Nummer', 'ICQ Nummer', 11, 0, 1);
INSERT INTO prefix_profilefields VALUES (8, 'Geburtsdatum', 'Geburtsdatum', 1, 0, 1);
INSERT INTO prefix_profilefields VALUES (9, 'Geschlecht', 'Geschlecht', 3, 0, 1);
INSERT INTO prefix_profilefields VALUES (10, 'Nationalitt', 'Nationalitt', 4, 0, 5);
INSERT INTO prefix_profilefields VALUES (11, 'zur Zeit aktiv?', 'Status', 2, 0, 3);
INSERT INTO prefix_profilefields VALUES (12, 'Kontakt', 'Kontakt', 7, 0, 6);

INSERT INTO prefix_ranks VALUES (1, 'Grnschnabel', 1, 0);
INSERT INTO prefix_ranks VALUES (2, 'Jungspund', 25, 0);
INSERT INTO prefix_ranks VALUES (3, 'Mitglied', 50, 0);
INSERT INTO prefix_ranks VALUES (4, 'Eroberer', 75, 0);
INSERT INTO prefix_ranks VALUES (6, 'Doppel-As', 150, 0);
INSERT INTO prefix_ranks VALUES (7, 'Tripel-As', 250, 0);
INSERT INTO prefix_ranks VALUES (8, 'Haudegen', 500, 0);
INSERT INTO prefix_ranks VALUES (9, 'Routinier', 1000, 0);
INSERT INTO prefix_ranks VALUES (10, 'Knig', 2000, 0);
INSERT INTO prefix_ranks VALUES (11, 'Kaiser', 5000, 0);
INSERT INTO prefix_ranks VALUES (12, 'Legende', 7000, 0);
INSERT INTO prefix_ranks VALUES (13, 'Foren Gott', 10000, 0);
INSERT INTO prefix_ranks VALUES (14, 'Administrator', 0, 1);

INSERT INTO prefix_smilies VALUES (1, ':)', 'include/images/smiles/1.gif');
INSERT INTO prefix_smilies VALUES (2, ':D', 'include/images/smiles/2.gif');
INSERT INTO prefix_smilies VALUES (3, ':O', 'include/images/smiles/3.gif');
INSERT INTO prefix_smilies VALUES (4, ':P', 'include/images/smiles/4.gif');
INSERT INTO prefix_smilies VALUES (5, '', 'include/images/smiles/5.gif');
INSERT INTO prefix_smilies VALUES (6, ':(', 'include/images/smiles/6.gif');
INSERT INTO prefix_smilies VALUES (7, ':S', 'include/images/smiles/7.gif');
INSERT INTO prefix_smilies VALUES (8, ':|', 'include/images/smiles/8.gif');